#!/bin/bash
#Copy this  script and permission.py  to any cluster node in the same directory location
#Make the script executable
#RUN the script as below
#./create_metadata.sh <hdfs_directory>

if [ $# -lt 1 ]
  then
    echo "$(tput setaf 5)Usage:$(tput sgr 0)"
    echo "./create_metadata.sh <arguments>"
    echo "$(tput setaf 5)Arguments:$(tput sgr 0)"
    echo "Directory path         Directory you want to migrate.  Mandatory Argument"
    echo "$(tput setaf 5)Examples: $(tput sgr 0)"
    echo "./create_metadata.sh /user"
    exit 1
fi

NUM_FILES=$(( $( hadoop fs -ls -R $1| wc -l ) +1 ))

rm -f Metadata*
hadoop fs -rm -f /metadata/Metadata* &> /dev/null

LOG_FILE="/tmp/create_permissions.log"
echo "*************************************************************" >> $LOG_FILE
echo "$(date): Number of files to process = $NUM_FILES" >> $LOG_FILE
echo "$(date): Creating permissions for $1" >> $LOG_FILE

python create_permissions.py $1 >> $LOG_FILE 2>&1
NUM_ENTRIES=`cat Metadata | wc -l`

echo "Number of files processed = $NUM_ENTRIES" >> $LOG_FILE
if [ $NUM_FILES -eq $NUM_ENTRIES ]
then
        echo "$(date): INFO: All files Processed" >> $LOG_FILE
else
        echo "$(date): ERROR: All files not Preocessed. Please check and rerun" >> $LOG_FILE
fi

split -l 1000 Metadata Metadata

#Check if metadata directory exists
hdfs dfs -test -d /metadata
rc=$?
if [ $rc -eq 0 ];
        then
		:
        else
                hadoop fs -mkdir /metadata;
fi
rm -f Metadata
hadoop fs -put Metadata* /metadata
rm -f Metadata*

